<?php
namespace lib\field;

class Checkbox extends \lib\Field
{
	public $type = 'checkbox';
	
	public function __construct($name, $value=null)
	{
		$this->name = $name;
		$this->value = $value?1:0;
		$this->validation = array();
	}
	
	public function setValue($value)
	{
		$this->value = $value?1:0;
	}
	
	public function input()
	{
		return '<input class="checkbox" type="checkbox" name="'.$this->name.'['.$this->form->bulk.']"'.($this->value?' checked':'').'/>';
	}
}